/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.util.Arrays;
import org.eclipse.californium.core.coap.BlockOption;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.OptionNumberRegistry;

public class Option
implements Comparable<Option> {
    private int number;
    private byte[] value;

    public Option() {
        this.value = new byte[0];
    }

    public Option(int number) {
        this.number = number;
        this.value = new byte[0];
    }

    public Option(int number, String str) {
        this.number = number;
        this.setStringValue(str);
    }

    public Option(int number, int val) {
        this.number = number;
        this.setIntegerValue(val);
    }

    public Option(int number, long val) {
        this.number = number;
        this.setLongValue(val);
    }

    public Option(int number, byte[] opaque) {
        this.number = number;
        this.setValue(opaque);
    }

    public int getLength() {
        return this.value.length;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public byte[] getValue() {
        return this.value;
    }

    public String getStringValue() {
        return new String(this.value, CoAP.UTF8_CHARSET);
    }

    public int getIntegerValue() {
        int ret = 0;
        int i = 0;
        while (i < this.value.length) {
            ret += (this.value[this.value.length - i - 1] & 0xFF) << i * 8;
            ++i;
        }
        return ret;
    }

    public long getLongValue() {
        long ret = 0L;
        int i = 0;
        while (i < this.value.length) {
            ret += (long)(this.value[this.value.length - i - 1] & 0xFF) << i * 8;
            ++i;
        }
        return ret;
    }

    public void setValue(byte[] value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.value = value;
    }

    public void setStringValue(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        this.value = str.getBytes(CoAP.UTF8_CHARSET);
    }

    public void setIntegerValue(int val) {
        int length = 0;
        int i = 0;
        while (i < 4) {
            if (val < 1 << i * 8 && val >= 0) break;
            ++length;
            ++i;
        }
        this.value = new byte[length];
        i = 0;
        while (i < length) {
            this.value[length - i - 1] = (byte)(val >> i * 8);
            ++i;
        }
    }

    public void setLongValue(long val) {
        int length = 0;
        int i = 0;
        while (i < 8) {
            if (val < 1L << i * 8 && val >= 0L) break;
            ++length;
            ++i;
        }
        this.value = new byte[length];
        i = 0;
        while (i < length) {
            this.value[length - i - 1] = (byte)(val >> i * 8);
            ++i;
        }
    }

    public boolean isCritical() {
        return (this.number & 1) != 0;
    }

    public boolean isUnSafe() {
        return (this.number & 2) != 0;
    }

    public boolean isNoCacheKey() {
        return (this.number & 0x1E) == 28;
    }

    @Override
    public int compareTo(Option o) {
        return this.number - o.number;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Option)) {
            return false;
        }
        Option op = (Option)o;
        return this.number == op.number && Arrays.equals(this.value, op.value);
    }

    public int hashCode() {
        return this.number * 31 + this.value.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OptionNumberRegistry.toString(this.number));
        sb.append(": ");
        sb.append(this.toValueString());
        return sb.toString();
    }

    public String toValueString() {
        switch (OptionNumberRegistry.getFormatByNr(this.number)) {
            case INTEGER: {
                if (this.number == 17 || this.number == 12) {
                    return "\"" + MediaTypeRegistry.toString(this.getIntegerValue()) + "\"";
                }
                if (this.number == 27 || this.number == 23) {
                    return "\"" + new BlockOption(this.value) + "\"";
                }
                return Integer.toString(this.getIntegerValue());
            }
            case STRING: {
                return "\"" + this.getStringValue() + "\"";
            }
        }
        return this.toHexString(this.getValue());
    }

    private String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        sb.append("0x");
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format("%02x", b & 0xFF));
            ++n2;
        }
        return sb.toString();
    }
}

