/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack.congestioncontrol;

import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.RemoteEndpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.stack.CongestionControlLayer;

public class Cocoa
extends CongestionControlLayer {
    private static final int KSTRONG = 4;
    private static final int KWEAK = 1;
    private static final double ALPHA = 0.25;
    private static final double BETA = 0.125;
    private static final double STRONGWEIGHTING = 0.5;
    private static final double WEAKWEIGHTING = 0.25;
    private int[] kValue = new int[]{4, 1};
    private double[] weighting = new double[]{0.5, 0.25};
    private static final long LOWERVBFLIMIT = 1000L;
    private static final long UPPERVBFLIMIT = 3000L;
    private static final double VBFLOW = 3.0;
    private static final double VBFHIGH = 1.5;

    public Cocoa(NetworkConfig config) {
        super(config);
        this.setDithering(true);
    }

    @Override
    public void initializeRTOEstimators(long measuredRTT, int estimatorType, RemoteEndpoint endpoint) {
        long RTT = measuredRTT;
        long RTTVAR = measuredRTT / 2L;
        long RTO = RTT + (long)this.kValue[estimatorType - 1] * RTTVAR;
        long newRTO = Math.round((double)RTO * this.weighting[estimatorType - 1] + (double)Math.round((double)endpoint.getRTO() * (1.0 - this.weighting[estimatorType - 1])));
        endpoint.setEstimatorValues(RTO, RTT, RTTVAR, estimatorType);
        endpoint.setRTOtimestamp(System.currentTimeMillis(), estimatorType);
        endpoint.setRTOtimestamp(System.currentTimeMillis(), 0);
        endpoint.updateRTO(newRTO);
    }

    @Override
    protected void updateEstimator(long measuredRTT, int estimatorType, RemoteEndpoint endpoint) {
        long RTTVAR = Math.round(0.875 * (double)endpoint.getxRTTVAR(estimatorType)) + Math.round(0.125 * (double)Math.abs(endpoint.getxRTT(estimatorType) - measuredRTT));
        long RTT = Math.round((double)endpoint.getxRTT(estimatorType) * 0.75) + Math.round((double)measuredRTT * 0.25);
        long RTO = RTT + (long)this.kValue[estimatorType - 1] * RTTVAR;
        long newRTO = Math.round((double)RTO * this.weighting[estimatorType - 1] + (double)Math.round((double)endpoint.getRTO() * (1.0 - this.weighting[estimatorType - 1])));
        endpoint.setEstimatorValues(RTO, RTT, RTTVAR, estimatorType);
        endpoint.setRTOtimestamp(System.currentTimeMillis(), estimatorType);
        endpoint.setRTOtimestamp(System.currentTimeMillis(), 0);
        endpoint.updateRTO(newRTO);
    }

    @Override
    public void processRTTmeasurement(long measuredRTT, Exchange exchange, int retransmissionCount) {
        RemoteEndpoint endpoint = this.getRemoteEndpoint(exchange);
        int rtoType = endpoint.getExchangeEstimatorState(exchange);
        if (rtoType == 3) {
            return;
        }
        endpoint.matchCurrentRTO();
        if (endpoint.isBlindWeak() && rtoType == 2) {
            endpoint.setBlindWeak(false);
            this.initializeRTOEstimators(measuredRTT, 2, endpoint);
        } else if (endpoint.isBlindStrong() && rtoType == 1) {
            endpoint.setBlindStrong(false);
            this.initializeRTOEstimators(measuredRTT, 1, endpoint);
        } else {
            this.updateEstimator(measuredRTT, rtoType, endpoint);
        }
    }

    @Override
    public double calculateVBF(long rto) {
        if (rto > 3000L) {
            return 1.5;
        }
        if (rto < 1000L) {
            return 3.0;
        }
        return this.config.getFloat("ACK_TIMEOUT_SCALE");
    }

    @Override
    public void checkAging(Exchange exchange) {
        long overallDifference;
        for (overallDifference = System.currentTimeMillis() - this.getRemoteEndpoint(exchange).getRTOtimestamp(0); overallDifference > 16L * this.getRemoteEndpoint(exchange).getRTO() && this.getRemoteEndpoint(exchange).getRTO() < 1000L; overallDifference -= 16L * this.getRemoteEndpoint(exchange).getRTO()) {
            this.getRemoteEndpoint(exchange).boostRTOvalue();
            this.getRemoteEndpoint(exchange).setRTOtimestamp(System.currentTimeMillis(), 0);
        }
        while (overallDifference > 4L * this.getRemoteEndpoint(exchange).getRTO() && this.getRemoteEndpoint(exchange).getRTO() > 3000L) {
            overallDifference -= 4L * this.getRemoteEndpoint(exchange).getRTO();
            this.getRemoteEndpoint(exchange).reduceRTOvalue();
            this.getRemoteEndpoint(exchange).setRTOtimestamp(System.currentTimeMillis(), 0);
        }
    }
}

