/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.eclipse.californium.core.CaliforniumFormatter;
import org.eclipse.californium.elements.Connector;

public class CaliforniumLogger {
    private static final Logger CALIFORNIUM_LOGGER = Logger.getLogger(CaliforniumLogger.class.getPackage().getName());
    private static final Logger CONNECTOR_LOGGER = Logger.getLogger(Connector.class.getPackage().getName());

    public static void initialize() {
        CALIFORNIUM_LOGGER.setUseParentHandlers(false);
        CALIFORNIUM_LOGGER.addHandler(new CaliforniumHandler());
        CONNECTOR_LOGGER.setUseParentHandlers(false);
        CONNECTOR_LOGGER.addHandler(new CaliforniumHandler());
    }

    public static void disableLogging() {
        CALIFORNIUM_LOGGER.setLevel(Level.OFF);
        CONNECTOR_LOGGER.setLevel(Level.OFF);
    }

    public static void setLevel(Level level) {
        CALIFORNIUM_LOGGER.setLevel(level);
        CONNECTOR_LOGGER.setLevel(level);
    }

    private static class CaliforniumHandler
    extends StreamHandler {
        public CaliforniumHandler() {
            super(System.out, new CaliforniumFormatter());
            this.setLevel(Level.ALL);
        }

        @Override
        public synchronized void publish(LogRecord record) {
            super.publish(record);
            super.flush();
        }
    }
}

