/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;

public final class Utils {
    static final ThreadGroup COAP_THREAD_GROUP = new ThreadGroup("Californium");

    private Utils() {
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        if (bytes == null) {
            sb.append("null");
        } else {
            byte[] byArray = bytes;
            int n = bytes.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                sb.append(String.format("%02x", b & 0xFF));
                ++n2;
            }
        }
        return sb.toString();
    }

    public static String toHexText(byte[] bytes, int length) {
        if (bytes == null) {
            return "null";
        }
        if (length > bytes.length) {
            length = bytes.length;
        }
        StringBuilder sb = new StringBuilder();
        if (16 < length) {
            sb.append('\n');
        }
        int index = 0;
        while (index < length) {
            sb.append(String.format("%02x", bytes[index] & 0xFF));
            if (31 == (0x1F & index)) {
                sb.append('\n');
            } else {
                sb.append(' ');
            }
            ++index;
        }
        if (length < bytes.length) {
            sb.append(" .. ").append(bytes.length).append(" bytes");
        }
        return sb.toString();
    }

    public static String prettyPrint(Request r) {
        StringBuilder sb = new StringBuilder();
        sb.append("==[ CoAP Request ]=============================================\n");
        sb.append(String.format("MID    : %d\n", r.getMID()));
        sb.append(String.format("Token  : %s\n", r.getTokenString()));
        sb.append(String.format("Type   : %s\n", r.getType().toString()));
        sb.append(String.format("Method : %s\n", r.getCode().toString()));
        sb.append(String.format("Options: %s\n", r.getOptions().toString()));
        sb.append(String.format("Payload: %d Bytes\n", r.getPayloadSize()));
        if (r.getPayloadSize() > 0 && MediaTypeRegistry.isPrintable(r.getOptions().getContentFormat())) {
            sb.append("---------------------------------------------------------------");
            sb.append(r.getPayloadString());
        }
        sb.append("===============================================================");
        return sb.toString();
    }

    public static String prettyPrint(CoapResponse r) {
        return Utils.prettyPrint(r.advanced());
    }

    public static String prettyPrint(Response r) {
        StringBuilder sb = new StringBuilder();
        sb.append("==[ CoAP Response ]============================================\n");
        sb.append(String.format("MID    : %d\n", r.getMID()));
        sb.append(String.format("Token  : %s\n", r.getTokenString()));
        sb.append(String.format("Type   : %s\n", r.getType().toString()));
        sb.append(String.format("Status : %s\n", r.getCode().toString()));
        sb.append(String.format("Options: %s\n", r.getOptions().toString()));
        sb.append(String.format("Payload: %d Bytes\n", r.getPayloadSize()));
        if (r.getPayloadSize() > 0 && MediaTypeRegistry.isPrintable(r.getOptions().getContentFormat())) {
            sb.append("---------------------------------------------------------------\n");
            sb.append(r.getPayloadString());
            sb.append("\n");
        }
        sb.append("===============================================================");
        return sb.toString();
    }

    public static class DaemonThreadFactory
    extends NamedThreadFactory {
        public DaemonThreadFactory(String threadPrefix) {
            super(threadPrefix, null);
        }

        public DaemonThreadFactory(String threadPrefix, ThreadGroup threadGroup) {
            super(threadPrefix, threadGroup);
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = super.newThread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    }

    public static class NamedThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger index = new AtomicInteger(1);
        private final String prefix;

        public NamedThreadFactory(String threadPrefix) {
            this(threadPrefix, null);
        }

        public NamedThreadFactory(String threadPrefix, ThreadGroup threadGroup) {
            this.group = threadGroup == null ? COAP_THREAD_GROUP : threadGroup;
            this.prefix = threadPrefix;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread ret = new Thread(this.group, runnable, String.valueOf(this.prefix) + this.index.getAndIncrement(), 0L);
            if (ret.isDaemon()) {
                ret.setDaemon(false);
            }
            if (ret.getPriority() != 5) {
                ret.setPriority(5);
            }
            return ret;
        }
    }
}

