/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.BaseMatcher;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.ExchangeObserver;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.elements.CorrelationContext;

public final class TcpMatcher
extends BaseMatcher {
    private static final Logger LOGGER = Logger.getLogger(TcpMatcher.class.getName());
    private final ExchangeObserver exchangeObserver = new ExchangeObserverImpl();

    public TcpMatcher(NetworkConfig config) {
        super(config);
    }

    @Override
    public void sendRequest(Exchange exchange, Request request) {
        exchange.setObserver(this.exchangeObserver);
        this.exchangeStore.registerOutboundRequestWithTokenOnly(exchange);
        LOGGER.log(Level.FINE, "Tracking open request using {0}", new Object[]{request.getTokenString()});
    }

    @Override
    public void sendResponse(Exchange exchange, Response response) {
        response.setToken(exchange.getCurrentRequest().getToken());
        if (response.getOptions().hasBlock2()) {
            Request request = exchange.getCurrentRequest();
            Exchange.KeyUri idByUri = new Exchange.KeyUri(request.getURI(), response.getDestination().getAddress(), response.getDestinationPort());
            if (exchange.getResponseBlockStatus() != null && !response.getOptions().hasObserve()) {
                if (this.exchangeStore.registerBlockwiseExchange(idByUri, exchange) == null) {
                    LOGGER.log(Level.FINE, "Ongoing Block2 started late, storing {0} for {1}", new Object[]{idByUri, request});
                } else {
                    LOGGER.log(Level.FINE, "Ongoing Block2 continued, storing {0} for {1}", new Object[]{idByUri, request});
                }
            } else {
                LOGGER.log(Level.FINE, "Ongoing Block2 completed, cleaning up {0} for {1}", new Object[]{idByUri, request});
                this.exchangeStore.remove(idByUri);
            }
        }
        if (response.isLast()) {
            exchange.setComplete();
        }
    }

    @Override
    public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
        if (!message.isConfirmable()) {
            throw new UnsupportedOperationException("sending empty message (ACK/RST) over tcp is not supported!");
        }
        message.setToken(new byte[0]);
    }

    @Override
    public Exchange receiveRequest(Request request) {
        if (!request.getOptions().hasBlock1() && !request.getOptions().hasBlock2()) {
            Exchange exchange = new Exchange(request, Exchange.Origin.REMOTE);
            exchange.setObserver(this.exchangeObserver);
            return exchange;
        }
        Exchange.KeyUri idByUri = new Exchange.KeyUri(request.getURI(), request.getSource().getAddress(), request.getSourcePort());
        LOGGER.log(Level.FINE, "Looking up ongoing exchange for {0}", idByUri);
        Exchange ongoing = this.exchangeStore.get(idByUri);
        if (ongoing != null) {
            return ongoing;
        }
        Exchange exchange = new Exchange(request, Exchange.Origin.REMOTE);
        LOGGER.log(Level.FINER, "New ongoing request, storing {0} for {1}", new Object[]{idByUri, request});
        exchange.setObserver(this.exchangeObserver);
        this.exchangeStore.registerBlockwiseExchange(idByUri, exchange);
        return exchange;
    }

    @Override
    public Exchange receiveResponse(Response response, CorrelationContext responseContext) {
        Exchange.KeyToken idByToken = Exchange.KeyToken.fromInboundMessage(response);
        Exchange exchange = this.exchangeStore.get(idByToken);
        if (exchange == null) {
            return null;
        }
        if (this.isResponseRelatedToRequest(exchange, responseContext)) {
            return exchange;
        }
        LOGGER.log(Level.INFO, "Ignoring potentially forged response for token {0} with non-matching correlation context", idByToken);
        return null;
    }

    private boolean isResponseRelatedToRequest(Exchange exchange, CorrelationContext responseContext) {
        return exchange.getCorrelationContext() == null || exchange.getCorrelationContext().equals(responseContext);
    }

    @Override
    public Exchange receiveEmptyMessage(EmptyMessage message) {
        return null;
    }

    private class ExchangeObserverImpl
    implements ExchangeObserver {
        private ExchangeObserverImpl() {
        }

        @Override
        public void completed(Exchange exchange) {
            if (exchange.getOrigin() == Exchange.Origin.LOCAL) {
                Exchange.KeyToken idByToken = Exchange.KeyToken.fromOutboundMessage(exchange.getCurrentRequest());
                TcpMatcher.this.exchangeStore.remove(idByToken);
                if (!exchange.getCurrentRequest().getOptions().hasObserve()) {
                    TcpMatcher.this.exchangeStore.releaseToken(idByToken);
                }
            } else {
                Response response = exchange.getCurrentResponse();
                Request request = exchange.getCurrentRequest();
                if (request != null && (request.getOptions().hasBlock1() || response.getOptions().hasBlock2())) {
                    Exchange.KeyUri uriKey = new Exchange.KeyUri(request.getURI(), request.getSource().getAddress(), request.getSourcePort());
                    LOGGER.log(Level.FINE, "Remote ongoing completed, cleaning up ", uriKey);
                    TcpMatcher.this.exchangeStore.remove(uriKey);
                }
            }
        }

        @Override
        public void contextEstablished(Exchange exchange) {
            Exchange.KeyToken token = Exchange.KeyToken.fromOutboundMessage(exchange.getCurrentRequest());
            TcpMatcher.this.exchangeStore.setContext(token, exchange.getCorrelationContext());
        }
    }
}

