/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.config;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.network.config.NetworkConfigDefaults;
import org.eclipse.californium.core.network.config.NetworkConfigObserver;

public final class NetworkConfig {
    private static final Logger LOGGER = Logger.getLogger(NetworkConfig.class.getName());
    public static final String DEFAULT_FILE_NAME = "Californium.properties";
    public static final String DEFAULT_HEADER = "Californium CoAP Properties file";
    private static NetworkConfig standard;
    private Properties properties;
    private List<NetworkConfigObserver> observers = new LinkedList<NetworkConfigObserver>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetworkConfig getStandard() {
        Class<NetworkConfig> clazz = NetworkConfig.class;
        synchronized (NetworkConfig.class) {
            if (standard == null) {
                NetworkConfig.createStandardWithFile(new File(DEFAULT_FILE_NAME));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return standard;
        }
    }

    public static void setStandard(NetworkConfig standard) {
        NetworkConfig.standard = standard;
    }

    public static NetworkConfig createStandardWithoutFile() {
        LOGGER.config("Creating standard network configuration properties without a file");
        standard = new NetworkConfig();
        return standard;
    }

    public static NetworkConfig createStandardWithFile(File file) {
        standard = new NetworkConfig();
        if (file.exists()) {
            standard.load(file);
        } else {
            standard.store(file);
        }
        return standard;
    }

    public NetworkConfig() {
        this.properties = new Properties();
        NetworkConfigDefaults.setDefaults(this);
    }

    public void load(File file) {
        block6: {
            if (file == null) {
                throw new NullPointerException("file must not be null");
            }
            LOGGER.log(Level.INFO, "loading properties from file {0}", file.getAbsolutePath());
            FileInputStream inStream = null;
            try {
                try {
                    inStream = new FileInputStream(file);
                    this.properties.load(inStream);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "cannot load properties from file {0}: {1}", new Object[]{file.getAbsolutePath(), e.getMessage()});
                    NetworkConfig.closeStream(inStream);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                NetworkConfig.closeStream(inStream);
                throw throwable;
            }
            NetworkConfig.closeStream(inStream);
        }
    }

    public void store(File file) {
        this.store(file, DEFAULT_HEADER);
    }

    public void store(File file, String header) {
        block6: {
            if (file == null) {
                throw new NullPointerException("file must not be null");
            }
            LOGGER.log(Level.INFO, "writing properties to file {0}", file.getAbsolutePath());
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(file);
                    this.properties.store(writer, header);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "cannot write properties to file {0}: {1}", new Object[]{file.getAbsolutePath(), e.getMessage()});
                    NetworkConfig.closeStream(writer);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                NetworkConfig.closeStream(writer);
                throw throwable;
            }
            NetworkConfig.closeStream(writer);
        }
    }

    private static void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getString(String key) {
        return this.properties.getProperty(key);
    }

    public String getString(String key, String defaultValue) {
        String result = this.properties.getProperty(key);
        return result != null ? result : defaultValue;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        return this.getNumberValue(new PropertyParser<Integer>(){

            @Override
            public Integer parseValue(String value) {
                return Integer.parseInt(value);
            }
        }, key, defaultValue);
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        return this.getNumberValue(new PropertyParser<Long>(){

            @Override
            public Long parseValue(String value) {
                return Long.parseLong(value);
            }
        }, key, defaultValue);
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float defaultValue) {
        return this.getNumberValue(new PropertyParser<Float>(){

            @Override
            public Float parseValue(String value) {
                return Float.valueOf(Float.parseFloat(value));
            }
        }, key, Float.valueOf(defaultValue)).floatValue();
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        return this.getNumberValue(new PropertyParser<Double>(){

            @Override
            public Double parseValue(String value) {
                return Double.parseDouble(value);
            }
        }, key, defaultValue);
    }

    private <T> T getNumberValue(PropertyParser<T> parser, String key, T defaultValue) {
        T result = defaultValue;
        String value = this.properties.getProperty(key);
        if (value != null) {
            try {
                result = parser.parseValue(value);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "value for key [{0}] is not a {1}, returning default value", new Object[]{key, defaultValue.getClass()});
            }
        } else {
            LOGGER.log(Level.WARNING, "key [{0}] is undefined, returning default value", key);
        }
        return result;
    }

    public boolean getBoolean(String key) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        LOGGER.log(Level.WARNING, "Key [{0}] is undefined", key);
        return false;
    }

    public NetworkConfig set(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        if (value == null) {
            throw new NullPointerException("value must not be null");
        }
        this.properties.put(key, String.valueOf(value));
        for (NetworkConfigObserver obs : this.observers) {
            obs.changed(key, value);
        }
        return this;
    }

    public NetworkConfig setString(String key, String value) {
        return this.set(key, value);
    }

    public NetworkConfig setInt(String key, int value) {
        return this.set(key, String.valueOf(value));
    }

    public NetworkConfig setLong(String key, long value) {
        return this.set(key, String.valueOf(value));
    }

    public NetworkConfig setFloat(String key, float value) {
        return this.set(key, String.valueOf(value));
    }

    public NetworkConfig setDouble(String key, double value) {
        return this.set(key, String.valueOf(value));
    }

    public NetworkConfig setBoolean(String key, boolean value) {
        return this.set(key, String.valueOf(value));
    }

    public NetworkConfig addConfigObserver(NetworkConfigObserver observer) {
        this.observers.add(observer);
        return this;
    }

    public NetworkConfig removeConfigObserver(NetworkConfigObserver observer) {
        this.observers.remove(observer);
        return this;
    }

    public class Keys {
        public static final String MAX_ACTIVE_PEERS = "MAX_ACTIVE_PEERS";
        public static final String MAX_PEER_INACTIVITY_PERIOD = "MAX_PEER_INACTIVITY_PERIOD";
        public static final String COAP_PORT = "COAP_PORT";
        public static final String COAP_SECURE_PORT = "COAP_SECURE_PORT";
        public static final String ACK_TIMEOUT = "ACK_TIMEOUT";
        public static final String ACK_RANDOM_FACTOR = "ACK_RANDOM_FACTOR";
        public static final String ACK_TIMEOUT_SCALE = "ACK_TIMEOUT_SCALE";
        public static final String MAX_RETRANSMIT = "MAX_RETRANSMIT";
        public static final String EXCHANGE_LIFETIME = "EXCHANGE_LIFETIME";
        public static final String NON_LIFETIME = "NON_LIFETIME";
        public static final String MAX_TRANSMIT_WAIT = "MAX_TRANSMIT_WAIT";
        public static final String NSTART = "NSTART";
        public static final String LEISURE = "LEISURE";
        public static final String PROBING_RATE = "PROBING_RATE";
        public static final String USE_RANDOM_MID_START = "USE_RANDOM_MID_START";
        public static final String TOKEN_SIZE_LIMIT = "TOKEN_SIZE_LIMIT";
        public static final String PREFERRED_BLOCK_SIZE = "PREFERRED_BLOCK_SIZE";
        public static final String MAX_MESSAGE_SIZE = "MAX_MESSAGE_SIZE";
        public static final String MAX_RESOURCE_BODY_SIZE = "MAX_RESOURCE_BODY_SIZE";
        public static final String BLOCKWISE_STATUS_LIFETIME = "BLOCKWISE_STATUS_LIFETIME";
        public static final String NOTIFICATION_CHECK_INTERVAL_TIME = "NOTIFICATION_CHECK_INTERVAL";
        public static final String NOTIFICATION_CHECK_INTERVAL_COUNT = "NOTIFICATION_CHECK_INTERVAL_COUNT";
        public static final String NOTIFICATION_REREGISTRATION_BACKOFF = "NOTIFICATION_REREGISTRATION_BACKOFF";
        public static final String USE_CONGESTION_CONTROL = "USE_CONGESTION_CONTROL";
        public static final String CONGESTION_CONTROL_ALGORITHM = "CONGESTION_CONTROL_ALGORITHM";
        public static final String PROTOCOL_STAGE_THREAD_COUNT = "PROTOCOL_STAGE_THREAD_COUNT";
        public static final String NETWORK_STAGE_RECEIVER_THREAD_COUNT = "NETWORK_STAGE_RECEIVER_THREAD_COUNT";
        public static final String NETWORK_STAGE_SENDER_THREAD_COUNT = "NETWORK_STAGE_SENDER_THREAD_COUNT";
        public static final String UDP_CONNECTOR_DATAGRAM_SIZE = "UDP_CONNECTOR_DATAGRAM_SIZE";
        public static final String UDP_CONNECTOR_RECEIVE_BUFFER = "UDP_CONNECTOR_RECEIVE_BUFFER";
        public static final String UDP_CONNECTOR_SEND_BUFFER = "UDP_CONNECTOR_SEND_BUFFER";
        public static final String UDP_CONNECTOR_OUT_CAPACITY = "UDP_CONNECTOR_OUT_CAPACITY";
        public static final String DEDUPLICATOR = "DEDUPLICATOR";
        public static final String DEDUPLICATOR_MARK_AND_SWEEP = "DEDUPLICATOR_MARK_AND_SWEEP";
        public static final String MARK_AND_SWEEP_INTERVAL = "MARK_AND_SWEEP_INTERVAL";
        public static final String DEDUPLICATOR_CROP_ROTATION = "DEDUPLICATOR_CROP_ROTATION";
        public static final String CROP_ROTATION_PERIOD = "CROP_ROTATION_PERIOD";
        public static final String NO_DEDUPLICATOR = "NO_DEDUPLICATOR";
        public static final String USE_STRICT_RESPONSE_MATCHING = "USE_STRICT_RESPONSE_MATCHING";
        public static final String HTTP_PORT = "HTTP_PORT";
        public static final String HTTP_SERVER_SOCKET_TIMEOUT = "HTTP_SERVER_SOCKET_TIMEOUT";
        public static final String HTTP_SERVER_SOCKET_BUFFER_SIZE = "HTTP_SERVER_SOCKET_BUFFER_SIZE";
        public static final String HTTP_CACHE_RESPONSE_MAX_AGE = "HTTP_CACHE_RESPONSE_MAX_AGE";
        public static final String HTTP_CACHE_SIZE = "HTTP_CACHE_SIZE";
        public static final String HEALTH_STATUS_PRINT_LEVEL = "HEALTH_STATUS_PRINT_LEVEL";
        public static final String HEALTH_STATUS_INTERVAL = "HEALTH_STATUS_INTERVAL";
        public static final String TCP_CONNECTION_IDLE_TIMEOUT = "TCP_CONNECTION_IDLE_TIMEOUT";
        public static final String TCP_CONNECT_TIMEOUT = "TCP_CONNECT_TIMEOUT";
        public static final String TCP_WORKER_THREADS = "TCP_WORKER_THREADS";
    }

    private static interface PropertyParser<T> {
        public T parseValue(String var1);
    }
}

