/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.serialization;

import java.net.InetSocketAddress;
import java.util.List;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.serialization.MessageHeader;
import org.eclipse.californium.elements.MessageCallback;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.util.DatagramWriter;

public abstract class DataSerializer {
    public final RawData serializeRequest(Request request) {
        return this.serializeRequest(request, null);
    }

    public final RawData serializeRequest(Request request, MessageCallback outboundCallback) {
        if (request.getBytes() == null) {
            request.setBytes(this.getByteArray(request));
        }
        return RawData.outbound(request.getBytes(), new InetSocketAddress(request.getDestination(), request.getDestinationPort()), outboundCallback, false);
    }

    public final byte[] getByteArray(Request request) {
        DatagramWriter writer = new DatagramWriter();
        byte[] body = DataSerializer.serializeOptionsAndPayload(request);
        MessageHeader header = new MessageHeader(1, request.getType(), request.getToken(), request.getRawCode(), request.getMID(), body.length);
        this.serializeHeader(writer, header);
        writer.writeBytes(body);
        return writer.toByteArray();
    }

    public final RawData serializeResponse(Response response) {
        if (response.getBytes() == null) {
            DatagramWriter writer = new DatagramWriter();
            byte[] body = DataSerializer.serializeOptionsAndPayload(response);
            MessageHeader header = new MessageHeader(1, response.getType(), response.getToken(), response.getCode().value, response.getMID(), body.length);
            this.serializeHeader(writer, header);
            writer.writeBytes(body);
            byte[] bytes = writer.toByteArray();
            response.setBytes(bytes);
        }
        return new RawData(response.getBytes(), response.getDestination(), response.getDestinationPort());
    }

    public final RawData serializeEmptyMessage(EmptyMessage emptyMessage) {
        if (emptyMessage.getBytes() == null) {
            DatagramWriter writer = new DatagramWriter();
            byte[] body = DataSerializer.serializeOptionsAndPayload(emptyMessage);
            MessageHeader header = new MessageHeader(1, emptyMessage.getType(), emptyMessage.getToken(), 0, emptyMessage.getMID(), body.length);
            this.serializeHeader(writer, header);
            writer.writeBytes(body);
            byte[] bytes = writer.toByteArray();
            emptyMessage.setBytes(bytes);
        }
        return new RawData(emptyMessage.getBytes(), emptyMessage.getDestination(), emptyMessage.getDestinationPort());
    }

    protected abstract void serializeHeader(DatagramWriter var1, MessageHeader var2);

    private static byte[] serializeOptionsAndPayload(Message message) {
        DatagramWriter writer = new DatagramWriter();
        List<Option> options = message.getOptions().asSortedList();
        int lastOptionNumber = 0;
        for (Option option : options) {
            int optionDelta = option.getNumber() - lastOptionNumber;
            int optionDeltaNibble = DataSerializer.getOptionNibble(optionDelta);
            writer.write(optionDeltaNibble, 4);
            int optionLength = option.getLength();
            int optionLengthNibble = DataSerializer.getOptionNibble(optionLength);
            writer.write(optionLengthNibble, 4);
            if (optionDeltaNibble == 13) {
                writer.write(optionDelta - 13, 8);
            } else if (optionDeltaNibble == 14) {
                writer.write(optionDelta - 269, 16);
            }
            if (optionLengthNibble == 13) {
                writer.write(optionLength - 13, 8);
            } else if (optionLengthNibble == 14) {
                writer.write(optionLength - 269, 16);
            }
            writer.writeBytes(option.getValue());
            lastOptionNumber = option.getNumber();
        }
        byte[] payload = message.getPayload();
        if (payload != null && payload.length > 0) {
            writer.writeByte((byte)-1);
            writer.writeBytes(payload);
        }
        return writer.toByteArray();
    }

    private static int getOptionNibble(int optionValue) {
        if (optionValue <= 12) {
            return optionValue;
        }
        if (optionValue <= 268) {
            return 13;
        }
        if (optionValue <= 65804) {
            return 14;
        }
        throw new IllegalArgumentException("Unsupported option delta " + optionValue);
    }
}

