/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.observe;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.californium.core.observe.ObserveRelation;

public class ObservingEndpoint {
    private final InetSocketAddress address;
    private final List<ObserveRelation> relations;

    public ObservingEndpoint(InetSocketAddress address) {
        this.address = address;
        this.relations = new CopyOnWriteArrayList<ObserveRelation>();
    }

    public void addObserveRelation(ObserveRelation relation) {
        this.relations.add(relation);
    }

    public void removeObserveRelation(ObserveRelation relation) {
        this.relations.remove(relation);
    }

    public void cancelAll() {
        for (ObserveRelation relation : this.relations) {
            relation.cancel();
        }
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public ObserveRelation getObserveRelation(byte[] token) {
        for (ObserveRelation relation : this.relations) {
            if (!Arrays.equals(relation.getExchange().getRequest().getToken(), token)) continue;
            return relation;
        }
        return null;
    }
}

