/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.server.MessageDeliverer;
import org.eclipse.californium.core.server.ServerInterface;
import org.eclipse.californium.core.server.ServerMessageDeliverer;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.core.server.resources.DiscoveryResource;
import org.eclipse.californium.core.server.resources.Resource;

public class CoapServer
implements ServerInterface {
    private static final Logger LOGGER = Logger.getLogger(CoapServer.class.getName());
    private final Resource root;
    private final NetworkConfig config;
    private MessageDeliverer deliverer;
    private final List<Endpoint> endpoints;
    private ScheduledExecutorService executor;
    private boolean running;

    public CoapServer() {
        this(NetworkConfig.getStandard(), new int[0]);
    }

    public CoapServer(int ... ports) {
        this(NetworkConfig.getStandard(), ports);
    }

    public CoapServer(NetworkConfig config, int ... ports) {
        this.config = config != null ? config : NetworkConfig.getStandard();
        this.root = this.createRoot();
        this.deliverer = new ServerMessageDeliverer(this.root);
        CoapResource wellKnown = new CoapResource(".well-known");
        wellKnown.setVisible(false);
        wellKnown.add((CoapResource)new DiscoveryResource(this.root));
        this.root.add(wellKnown);
        this.endpoints = new ArrayList<Endpoint>();
        this.executor = Executors.newScheduledThreadPool(config.getInt("PROTOCOL_STAGE_THREAD_COUNT"), new Utils.NamedThreadFactory("CoapServer#"));
        int[] nArray = ports;
        int n = ports.length;
        int n2 = 0;
        while (n2 < n) {
            int port = nArray[n2];
            this.addEndpoint(new CoapEndpoint(port, this.config));
            ++n2;
        }
    }

    public synchronized void setExecutor(ScheduledExecutorService executor) {
        if (this.running) {
            throw new IllegalStateException("executor service can not be set on running server");
        }
        this.executor = executor;
        for (Endpoint ep : this.endpoints) {
            ep.setExecutor(executor);
        }
    }

    @Override
    public synchronized void start() {
        if (this.running) {
            return;
        }
        LOGGER.info("Starting server");
        if (this.endpoints.isEmpty()) {
            int port = this.config.getInt("COAP_PORT");
            LOGGER.log(Level.INFO, "No endpoints have been defined for server, setting up server endpoint on default port {0}", port);
            this.addEndpoint(new CoapEndpoint(port, this.config));
        }
        int started = 0;
        for (Endpoint ep : this.endpoints) {
            try {
                ep.start();
                ++started;
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Cannot start server endpoint [" + ep.getAddress() + "]", e);
            }
        }
        if (started == 0) {
            throw new IllegalStateException("None of the server endpoints could be started");
        }
        this.running = true;
    }

    @Override
    public synchronized void stop() {
        if (this.running) {
            LOGGER.info("Stopping server");
            for (Endpoint ep : this.endpoints) {
                ep.stop();
            }
            this.running = false;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized void destroy() {
        block10: {
            block9: {
                CoapServer.LOGGER.info("Destroying server");
                this.executor.shutdown();
                try {
                    try {
                        if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                            runningTasks = this.executor.shutdownNow();
                            if (runningTasks.size() > 0) {
                                CoapServer.LOGGER.log(Level.FINE, "Ignoring remaining {0} scheduled task(s)", runningTasks.size());
                            }
                            this.executor.awaitTermination(1L, TimeUnit.SECONDS);
                        }
                        break block9;
                    }
                    catch (InterruptedException e) {
                        this.executor.shutdownNow();
                        Thread.currentThread().interrupt();
                        ** for (ep : this.endpoints)
                    }
                }
                catch (Throwable var2_9) {
                    ** for (ep : this.endpoints)
                }
lbl-1000:
                // 1 sources

                {
                    ep.destroy();
                    continue;
                }
lbl19:
                // 1 sources

                CoapServer.LOGGER.log(Level.INFO, "CoAP server has been destroyed");
                this.running = false;
                break block10;
lbl-1000:
                // 1 sources

                {
                    ep.destroy();
                    continue;
                }
lbl26:
                // 1 sources

                CoapServer.LOGGER.log(Level.INFO, "CoAP server has been destroyed");
                this.running = false;
                throw var2_9;
            }
            for (Endpoint ep : this.endpoints) {
                ep.destroy();
            }
            CoapServer.LOGGER.log(Level.INFO, "CoAP server has been destroyed");
            this.running = false;
        }
    }

    public void setMessageDeliverer(MessageDeliverer deliverer) {
        this.deliverer = deliverer;
        for (Endpoint endpoint : this.endpoints) {
            endpoint.setMessageDeliverer(deliverer);
        }
    }

    public MessageDeliverer getMessageDeliverer() {
        return this.deliverer;
    }

    @Override
    public void addEndpoint(Endpoint endpoint) {
        endpoint.setMessageDeliverer(this.deliverer);
        endpoint.setExecutor(this.executor);
        this.endpoints.add(endpoint);
    }

    @Override
    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    @Override
    public Endpoint getEndpoint(int port) {
        Endpoint endpoint = null;
        for (Endpoint ep : this.endpoints) {
            if (ep.getAddress().getPort() != port) continue;
            endpoint = ep;
        }
        return endpoint;
    }

    @Override
    public Endpoint getEndpoint(InetSocketAddress address) {
        Endpoint endpoint = null;
        for (Endpoint ep : this.endpoints) {
            if (!ep.getAddress().equals(address)) continue;
            endpoint = ep;
            break;
        }
        return endpoint;
    }

    @Override
    public CoapServer add(Resource ... resources) {
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            this.root.add(r);
            ++n2;
        }
        return this;
    }

    @Override
    public boolean remove(Resource resource) {
        return this.root.delete(resource);
    }

    public Resource getRoot() {
        return this.root;
    }

    protected Resource createRoot() {
        return new RootResource();
    }

    private class RootResource
    extends CoapResource {
        private static final String SPACE = "                                               ";
        private final String VERSION;
        private final String msg;

        public RootResource() {
            super("");
            this.VERSION = CoapServer.class.getPackage().getImplementationVersion() != null ? "Cf " + CoapServer.class.getPackage().getImplementationVersion() : SPACE;
            this.msg = "************************************************************\n" + "CoAP RFC 7252" + SPACE.substring(this.VERSION.length()) + this.VERSION + "\n" + "************************************************************\n" + "This server is using the Eclipse Californium (Cf) CoAP framework\n" + "published under EPL+EDL: http://www.eclipse.org/californium/\n" + "\n" + "(c) 2014, 2015, 2016 Institute for Pervasive Computing, ETH Zurich and others\n" + "************************************************************";
        }

        @Override
        public void handleGET(CoapExchange exchange) {
            exchange.respond(CoAP.ResponseCode.CONTENT, this.msg);
        }

        @Override
        public List<Endpoint> getEndpoints() {
            return CoapServer.this.getEndpoints();
        }
    }
}

