/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.nio.charset.Charset;

public final class CoAP {
    public static final int VERSION = 1;
    public static final String COAP_URI_SCHEME = "coap";
    public static final String COAP_TCP_URI_SCHEME = "coap+tcp";
    public static final String COAP_SECURE_TCP_URI_SCHEME = "coaps+tcp";
    public static final String COAP_SECURE_URI_SCHEME = "coaps";
    public static final int DEFAULT_COAP_PORT = 5683;
    public static final int DEFAULT_COAP_SECURE_PORT = 5684;
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

    private CoAP() {
    }

    public static int getCodeClass(int code) {
        return (code & 0xE0) >> 5;
    }

    public static int getCodeDetail(int code) {
        return code & 0x1F;
    }

    public static String formatCode(int code) {
        return CoAP.formatCode(CoAP.getCodeClass(code), CoAP.getCodeDetail(code));
    }

    private static String formatCode(int codeClass, int codeDetail) {
        return String.format("%d.%02d", codeClass, codeDetail);
    }

    public static boolean isTcpScheme(String uriScheme) {
        return COAP_TCP_URI_SCHEME.equalsIgnoreCase(uriScheme) || COAP_SECURE_TCP_URI_SCHEME.equalsIgnoreCase(uriScheme);
    }

    public static boolean isSecureScheme(String uriScheme) {
        return COAP_SECURE_URI_SCHEME.equalsIgnoreCase(uriScheme) || COAP_SECURE_TCP_URI_SCHEME.equalsIgnoreCase(uriScheme);
    }

    public static boolean isSupportedScheme(String uriScheme) {
        return COAP_URI_SCHEME.equalsIgnoreCase(uriScheme) || COAP_TCP_URI_SCHEME.equalsIgnoreCase(uriScheme) || COAP_SECURE_URI_SCHEME.equalsIgnoreCase(uriScheme) || COAP_SECURE_TCP_URI_SCHEME.equalsIgnoreCase(uriScheme);
    }

    public static int getDefaultPort(String uriScheme) {
        if (COAP_URI_SCHEME.equalsIgnoreCase(uriScheme)) {
            return 5683;
        }
        if (COAP_SECURE_URI_SCHEME.equalsIgnoreCase(uriScheme)) {
            return 5684;
        }
        if (COAP_TCP_URI_SCHEME.equalsIgnoreCase(uriScheme)) {
            return 5683;
        }
        if (COAP_SECURE_TCP_URI_SCHEME.equalsIgnoreCase(uriScheme)) {
            return 5684;
        }
        throw new IllegalArgumentException("URI scheme '" + uriScheme + "' is not supported!");
    }

    public static boolean isRequest(int code) {
        return code >= 1 && code <= 31;
    }

    public static boolean isResponse(int code) {
        return code >= 64 && code <= 191;
    }

    public static boolean isEmptyMessage(int code) {
        return code == 0;
    }

    public static enum Code {
        GET(1),
        POST(2),
        PUT(3),
        DELETE(4);

        public final int value;

        private Code(int value) {
            this.value = value;
        }

        public static Code valueOf(String string) {
            return Enum.valueOf(Code.class, string);
        }
    }

    public static enum CodeClass {
        REQUEST(0),
        SUCCESS_RESPONSE(2),
        ERROR_RESPONSE(4),
        SERVER_ERROR_RESPONSE(5),
        SIGNAL(7);

        public final int value;

        private CodeClass(int value) {
            this.value = value;
        }

        public static CodeClass valueOf(String string) {
            return Enum.valueOf(CodeClass.class, string);
        }
    }

    public final class MessageFormat {
        public static final int LENGTH_NIBBLE_BITS = 4;
        public static final int VERSION_BITS = 2;
        public static final int TYPE_BITS = 2;
        public static final int TOKEN_LENGTH_BITS = 4;
        public static final int CODE_BITS = 8;
        public static final int MESSAGE_ID_BITS = 16;
        public static final int OPTION_DELTA_BITS = 4;
        public static final int OPTION_LENGTH_BITS = 4;
        public static final byte PAYLOAD_MARKER = -1;
        public static final int VERSION = 1;
        public static final int EMPTY_CODE = 0;
        public static final int REQUEST_CODE_LOWER_BOUND = 1;
        public static final int REQUEST_CODE_UPPER_BOUND = 31;
        public static final int RESPONSE_CODE_LOWER_BOUND = 64;
        public static final int RESPONSE_CODE_UPPER_BOUND = 191;

        private MessageFormat() {
        }
    }

    public static enum ResponseCode {
        _UNKNOWN_SUCCESS_CODE(CodeClass.SUCCESS_RESPONSE, 0),
        CREATED(CodeClass.SUCCESS_RESPONSE, 1),
        DELETED(CodeClass.SUCCESS_RESPONSE, 2),
        VALID(CodeClass.SUCCESS_RESPONSE, 3),
        CHANGED(CodeClass.SUCCESS_RESPONSE, 4),
        CONTENT(CodeClass.SUCCESS_RESPONSE, 5),
        CONTINUE(CodeClass.SUCCESS_RESPONSE, 31),
        BAD_REQUEST(CodeClass.ERROR_RESPONSE, 0),
        UNAUTHORIZED(CodeClass.ERROR_RESPONSE, 1),
        BAD_OPTION(CodeClass.ERROR_RESPONSE, 2),
        FORBIDDEN(CodeClass.ERROR_RESPONSE, 3),
        NOT_FOUND(CodeClass.ERROR_RESPONSE, 4),
        METHOD_NOT_ALLOWED(CodeClass.ERROR_RESPONSE, 5),
        NOT_ACCEPTABLE(CodeClass.ERROR_RESPONSE, 6),
        REQUEST_ENTITY_INCOMPLETE(CodeClass.ERROR_RESPONSE, 8),
        PRECONDITION_FAILED(CodeClass.ERROR_RESPONSE, 12),
        REQUEST_ENTITY_TOO_LARGE(CodeClass.ERROR_RESPONSE, 13),
        UNSUPPORTED_CONTENT_FORMAT(CodeClass.ERROR_RESPONSE, 15),
        INTERNAL_SERVER_ERROR(CodeClass.SERVER_ERROR_RESPONSE, 0),
        NOT_IMPLEMENTED(CodeClass.SERVER_ERROR_RESPONSE, 1),
        BAD_GATEWAY(CodeClass.SERVER_ERROR_RESPONSE, 2),
        SERVICE_UNAVAILABLE(CodeClass.SERVER_ERROR_RESPONSE, 3),
        GATEWAY_TIMEOUT(CodeClass.SERVER_ERROR_RESPONSE, 4),
        PROXY_NOT_SUPPORTED(CodeClass.SERVER_ERROR_RESPONSE, 5);

        public final int value;
        public final int codeClass;
        public final int codeDetail;

        private ResponseCode(CodeClass codeClass, int codeDetail) {
            this.codeClass = codeClass.value;
            this.codeDetail = codeDetail;
            this.value = codeClass.value << 5 | codeDetail;
        }

        private static ResponseCode valueOfSuccessCode(int codeDetail) {
            switch (codeDetail) {
                case 1: {
                    return CREATED;
                }
                case 2: {
                    return DELETED;
                }
                case 3: {
                    return VALID;
                }
                case 4: {
                    return CHANGED;
                }
                case 5: {
                    return CONTENT;
                }
                case 31: {
                    return CONTINUE;
                }
            }
            return _UNKNOWN_SUCCESS_CODE;
        }

        private static ResponseCode valueOfClientErrorCode(int codeDetail) {
            switch (codeDetail) {
                case 0: {
                    return BAD_REQUEST;
                }
                case 1: {
                    return UNAUTHORIZED;
                }
                case 2: {
                    return BAD_OPTION;
                }
                case 3: {
                    return FORBIDDEN;
                }
                case 4: {
                    return NOT_FOUND;
                }
                case 5: {
                    return METHOD_NOT_ALLOWED;
                }
                case 6: {
                    return NOT_ACCEPTABLE;
                }
                case 8: {
                    return REQUEST_ENTITY_INCOMPLETE;
                }
                case 12: {
                    return PRECONDITION_FAILED;
                }
                case 13: {
                    return REQUEST_ENTITY_TOO_LARGE;
                }
                case 15: {
                    return UNSUPPORTED_CONTENT_FORMAT;
                }
            }
            return BAD_REQUEST;
        }

        private static ResponseCode valueOfServerErrorCode(int codeDetail) {
            switch (codeDetail) {
                case 0: {
                    return INTERNAL_SERVER_ERROR;
                }
                case 1: {
                    return NOT_IMPLEMENTED;
                }
                case 2: {
                    return BAD_GATEWAY;
                }
                case 3: {
                    return SERVICE_UNAVAILABLE;
                }
                case 4: {
                    return GATEWAY_TIMEOUT;
                }
                case 5: {
                    return PROXY_NOT_SUPPORTED;
                }
            }
            return INTERNAL_SERVER_ERROR;
        }

        public String toString() {
            return CoAP.formatCode(this.codeClass, this.codeDetail);
        }

        public static boolean isSuccess(ResponseCode code) {
            if (code == null) {
                throw new NullPointerException("ResponseCode must not be null!");
            }
            return code.codeClass == CodeClass.SUCCESS_RESPONSE.value;
        }

        public static boolean isClientError(ResponseCode code) {
            if (code == null) {
                throw new NullPointerException("ResponseCode must not be null!");
            }
            return code.codeClass == CodeClass.ERROR_RESPONSE.value;
        }

        public static boolean isServerError(ResponseCode code) {
            if (code == null) {
                throw new NullPointerException("ResponseCode must not be null!");
            }
            return code.codeClass == CodeClass.SERVER_ERROR_RESPONSE.value;
        }

        public static ResponseCode valueOf(String string) {
            return Enum.valueOf(ResponseCode.class, string);
        }
    }

    public static enum Type {
        CON(0),
        NON(1),
        ACK(2),
        RST(3);

        public final int value;

        private Type(int value) {
            this.value = value;
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }
}

