/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.MessageObserver;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.EndpointManager;

public class Request
extends Message {
    private static final Pattern IP_PATTERN = Pattern.compile("(\\[[0-9a-f:]+\\]|[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})");
    private final CoAP.Code code;
    private boolean multicast;
    private Response response;
    private String scheme;
    private Object lock;
    private Principal senderIdentity;

    public Request(CoAP.Code code) {
        this(code, CoAP.Type.CON);
    }

    public Request(CoAP.Code code, CoAP.Type type) {
        super(type);
        this.code = code;
    }

    public CoAP.Code getCode() {
        return this.code;
    }

    @Override
    public int getRawCode() {
        return this.code == null ? 0 : this.code.value;
    }

    public String getScheme() {
        return this.scheme == null ? "coap" : this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public boolean isMulticast() {
        return this.multicast;
    }

    public void setMulticast(boolean multicast) {
        this.multicast = multicast;
    }

    @Override
    public Request setPayload(String payload) {
        super.setPayload(payload);
        return this;
    }

    @Override
    public Request setPayload(byte[] payload) {
        super.setPayload(payload);
        return this;
    }

    public Request setURI(String uri) {
        if (uri == null) {
            throw new NullPointerException("URI must not be null");
        }
        try {
            String coapUri = uri;
            if (!(uri.startsWith("coap://") || uri.startsWith("coaps://") || uri.startsWith("coap+tcp://") || uri.startsWith("coaps+tcp://"))) {
                coapUri = "coap://" + uri;
                LOGGER.log(Level.WARNING, "update your code to supply an RFC 7252 compliant URI including a scheme");
            }
            return this.setURI(new URI(coapUri));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("invalid uri: " + uri, e);
        }
    }

    public Request setURI(URI uri) {
        if (uri == null) {
            throw new NullPointerException("URI must not be null");
        }
        String host = uri.getHost() == null ? "localhost" : uri.getHost();
        try {
            InetAddress destAddress = InetAddress.getByName(host);
            this.setDestination(destAddress);
            return this.setOptions(new URI(uri.getScheme(), null, host, uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("cannot resolve host name: " + host);
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.WARNING, "cannot set URI on request", e);
            throw new IllegalArgumentException(e);
        }
    }

    public Request setOptions(URI uri) {
        String query;
        String path;
        if (uri == null) {
            throw new NullPointerException("URI must not be null");
        }
        if (!Request.isSupportedScheme(uri.getScheme())) {
            throw new IllegalArgumentException("unsupported URI scheme: " + uri.getScheme());
        }
        if (uri.getFragment() != null) {
            throw new IllegalArgumentException("URI must not contain a fragment");
        }
        if (this.getDestination() == null) {
            throw new IllegalStateException("destination address must be set");
        }
        if (uri.getHost() != null) {
            String host = uri.getHost().toLowerCase();
            Matcher matcher = IP_PATTERN.matcher(host);
            if (matcher.matches()) {
                try {
                    InetAddress hostAddress = InetAddress.getByName(host);
                    if (!hostAddress.equals(this.getDestination())) {
                        throw new IllegalArgumentException("URI's literal host IP address does not match request's destination address");
                    }
                }
                catch (UnknownHostException e) {
                    LOGGER.warning("could not parse IP address of URI despite successful IP address pattern matching");
                }
            } else {
                this.getOptions().setUriHost(host);
            }
        }
        this.scheme = uri.getScheme().toLowerCase();
        int port = uri.getPort();
        if (port <= 0) {
            port = CoAP.getDefaultPort(this.scheme);
        }
        this.setDestinationPort(port);
        if (port != 5683) {
            this.getOptions().setUriPort(port);
        }
        if ((path = uri.getPath()) != null && path.length() > 1) {
            this.getOptions().setUriPath(path);
        }
        if ((query = uri.getQuery()) != null) {
            this.getOptions().setUriQuery(query);
        }
        return this;
    }

    private static boolean isSupportedScheme(String uriScheme) {
        boolean result = false;
        if (uriScheme != null) {
            String scheme = uriScheme.toLowerCase();
            result = "coap".equalsIgnoreCase(scheme) || "coaps".equalsIgnoreCase(scheme) || "coap+tcp".equalsIgnoreCase(scheme) || "coaps+tcp".equalsIgnoreCase(scheme);
        }
        return result;
    }

    public String getURI() {
        StringBuilder builder = new StringBuilder();
        if (this.getScheme() != null) {
            builder.append(this.getScheme()).append("://");
        } else {
            builder.append("coap://");
        }
        String host = this.getOptions().getUriHost();
        if (host != null) {
            builder.append(host);
        } else {
            builder.append("localhost");
        }
        Integer port = this.getOptions().getUriPort();
        if (port != null) {
            builder.append(":").append(port);
        }
        String path = this.getOptions().getUriPathString();
        builder.append("/").append(path);
        String query = this.getOptions().getUriQueryString();
        if (query.length() > 0) {
            builder.append("?").append(query);
        }
        return builder.toString();
    }

    public Principal getSenderIdentity() {
        return this.senderIdentity;
    }

    public Request setSenderIdentity(Principal senderIdentity) {
        this.senderIdentity = senderIdentity;
        return this;
    }

    public Request send() {
        this.validateBeforeSending();
        if ("coaps".equals(this.getScheme())) {
            EndpointManager.getEndpointManager().getDefaultSecureEndpoint().sendRequest(this);
        } else {
            EndpointManager.getEndpointManager().getDefaultEndpoint().sendRequest(this);
        }
        return this;
    }

    public Request send(Endpoint endpoint) {
        this.validateBeforeSending();
        endpoint.sendRequest(this);
        return this;
    }

    private void validateBeforeSending() {
        if (this.getDestination() == null) {
            throw new NullPointerException("Destination is null");
        }
        if (this.getDestinationPort() == 0) {
            throw new NullPointerException("Destination port is 0");
        }
    }

    public Request setObserve() {
        this.getOptions().setObserve(0);
        return this;
    }

    public Request setObserveCancel() {
        this.getOptions().setObserve(1);
        return this;
    }

    public Response getResponse() {
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponse(Response response) {
        this.response = response;
        if (this.lock != null) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
        for (MessageObserver handler : this.getMessageObservers()) {
            handler.onResponse(response);
        }
    }

    public Response waitForResponse() throws InterruptedException {
        return this.waitForResponse(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response waitForResponse(long timeout) throws InterruptedException {
        long before = System.currentTimeMillis();
        long expired = timeout > 0L ? before + timeout : 0L;
        Object object = this;
        synchronized (object) {
            if (this.lock == null) {
                this.lock = new Object();
            }
        }
        object = this.lock;
        synchronized (object) {
            while (!(this.response != null || this.isCanceled() || this.isTimedOut() || this.isRejected())) {
                this.lock.wait(timeout);
                long now = System.currentTimeMillis();
                if (timeout > 0L && expired <= now) break;
            }
            Response r = this.response;
            this.response = null;
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimedOut(boolean timedOut) {
        super.setTimedOut(timedOut);
        if (timedOut && this.lock != null) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCanceled(boolean canceled) {
        super.setCanceled(canceled);
        if (canceled && this.lock != null) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRejected(boolean rejected) {
        super.setRejected(rejected);
        if (rejected && this.lock != null) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    public String toString() {
        String payload = this.getPayloadTracingString();
        return String.format("%s-%-6s MID=%5d, Token=%s, OptionSet=%s, %s", new Object[]{this.getType(), this.getCode(), this.getMID(), this.getTokenString(), this.getOptions(), payload});
    }

    public static Request newGet() {
        return new Request(CoAP.Code.GET);
    }

    public static Request newPost() {
        return new Request(CoAP.Code.POST);
    }

    public static Request newPut() {
        return new Request(CoAP.Code.PUT);
    }

    public static Request newDelete() {
        return new Request(CoAP.Code.DELETE);
    }
}

