/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.ByteArrayInputStream;
import java.util.Arrays;

public final class DatagramReader {
    private final ByteArrayInputStream byteStream;
    private byte currentByte;
    private int currentBitIndex;

    public DatagramReader(byte[] byteArray) {
        this.byteStream = new ByteArrayInputStream(Arrays.copyOf(byteArray, byteArray.length));
        this.currentByte = 0;
        this.currentBitIndex = -1;
    }

    public long readLong(int numBits) {
        long bits = 0L;
        int i = numBits - 1;
        while (i >= 0) {
            boolean bit;
            if (this.currentBitIndex < 0) {
                this.readCurrentByte();
            }
            boolean bl = bit = (this.currentByte >> this.currentBitIndex & 1) != 0;
            if (bit) {
                bits |= 1L << i;
            }
            --this.currentBitIndex;
            --i;
        }
        return bits;
    }

    public int read(int numBits) {
        int bits = 0;
        int i = numBits - 1;
        while (i >= 0) {
            boolean bit;
            if (this.currentBitIndex < 0) {
                this.readCurrentByte();
            }
            boolean bl = bit = (this.currentByte >> this.currentBitIndex & 1) != 0;
            if (bit) {
                bits |= 1 << i;
            }
            --this.currentBitIndex;
            --i;
        }
        return bits;
    }

    public byte[] readBytes(int count) {
        int bytesToRead = count;
        if (bytesToRead < 0) {
            bytesToRead = this.byteStream.available();
        }
        byte[] bytes = new byte[bytesToRead];
        if (this.currentBitIndex >= 0) {
            int i = 0;
            while (i < bytesToRead) {
                bytes[i] = (byte)this.read(8);
                ++i;
            }
        } else {
            this.byteStream.read(bytes, 0, bytes.length);
        }
        return bytes;
    }

    public byte readNextByte() {
        byte[] bytes = this.readBytes(1);
        return bytes[0];
    }

    public byte[] readBytesLeft() {
        return this.readBytes(-1);
    }

    public boolean bytesAvailable() {
        return this.byteStream.available() > 0;
    }

    public boolean bytesAvailable(int expectedBytes) {
        int bytesLeft = this.byteStream.available();
        return bytesLeft >= expectedBytes;
    }

    public int bitsLeft() {
        return this.byteStream.available() * 8 + (this.currentBitIndex + 1);
    }

    private void readCurrentByte() {
        int val = this.byteStream.read();
        this.currentByte = val >= 0 ? (byte)val : (byte)0;
        this.currentBitIndex = 7;
    }
}

