/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.stack.AbstractLayer;

public class ExchangeCleanupLayer
extends AbstractLayer {
    @Override
    public void sendRequest(Exchange exchange, Request request) {
        request.addMessageObserver(new CancelledMessageObserver(exchange));
        this.lower().sendRequest(exchange, request);
    }

    private static class CancelledMessageObserver
    extends MessageObserverAdapter {
        private final Exchange exchange;

        CancelledMessageObserver(Exchange exchange) {
            this.exchange = exchange;
        }

        @Override
        public void onCancel() {
            if (!this.exchange.isComplete()) {
                this.exchange.setComplete();
            }
        }
    }
}

