/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.californium.core.network.config.NetworkConfig;

public class MessageIdTracker {
    private static final int TOTAL_NO_OF_MIDS = 65536;
    private final long exchangeLifetime;
    private Map<Integer, Long> messageIds;
    private AtomicInteger counter;

    public MessageIdTracker(NetworkConfig config) {
        this.exchangeLifetime = config.getLong("EXCHANGE_LIFETIME");
        boolean useRandomFirstMID = config.getBoolean("USE_RANDOM_MID_START");
        this.counter = useRandomFirstMID ? new AtomicInteger(new Random().nextInt(1024)) : new AtomicInteger(0);
        this.messageIds = new HashMap<Integer, Long>(65536);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextMessageId() {
        int result = -1;
        boolean wrapped = false;
        Map<Integer, Long> map = this.messageIds;
        synchronized (map) {
            int startIdx = this.counter.get() % 65536;
            while (result < 0 && !wrapped) {
                int idx = this.counter.getAndIncrement() % 65536;
                Long earliestUsage = this.messageIds.get(idx);
                if (earliestUsage != null) {
                    if (System.currentTimeMillis() >= earliestUsage) {
                        result = idx;
                        this.messageIds.put(idx, this.computeMidRetirementPeriod());
                    }
                } else {
                    result = idx;
                    this.messageIds.put(idx, this.computeMidRetirementPeriod());
                }
                boolean bl = wrapped = this.counter.get() % 65536 == startIdx;
            }
        }
        return result;
    }

    private long computeMidRetirementPeriod() {
        return System.currentTimeMillis() + this.exchangeLifetime;
    }
}

