/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.network.Outbox;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.stack.BaseCoapStack;
import org.eclipse.californium.core.network.stack.BlockwiseLayer;
import org.eclipse.californium.core.network.stack.CongestionControlLayer;
import org.eclipse.californium.core.network.stack.ExchangeCleanupLayer;
import org.eclipse.californium.core.network.stack.Layer;
import org.eclipse.californium.core.network.stack.ObserveLayer;
import org.eclipse.californium.core.network.stack.ReliabilityLayer;

public class CoapUdpStack
extends BaseCoapStack {
    private static final Logger LOGGER = Logger.getLogger(CoapUdpStack.class.getCanonicalName());

    public CoapUdpStack(NetworkConfig config, Outbox outbox) {
        super(outbox);
        ReliabilityLayer reliabilityLayer;
        if (config.getBoolean("USE_CONGESTION_CONTROL")) {
            reliabilityLayer = CongestionControlLayer.newImplementation(config);
            LOGGER.log(Level.CONFIG, "Enabling congestion control: {0}", reliabilityLayer.getClass().getSimpleName());
        } else {
            reliabilityLayer = new ReliabilityLayer(config);
        }
        Layer[] layers = new Layer[]{new ExchangeCleanupLayer(), new ObserveLayer(config), new BlockwiseLayer(config), reliabilityLayer};
        this.setLayers(layers);
    }
}

