/*
 * Decompiled with CFR 0.152.
 */
package de.haw.inet.ttvs;

import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.server.resources.CoapExchange;

public class CoAPDummyLED
extends CoapResource {
    private boolean red = false;
    private boolean green = false;
    private boolean blue = false;

    public CoAPDummyLED(String name) {
        super(name);
    }

    public CoAPDummyLED() {
        super("led");
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        String ledState = "(";
        ledState = String.valueOf(ledState) + (this.red ? "255," : "0,");
        ledState = String.valueOf(ledState) + (this.green ? "255," : "0,");
        ledState = String.valueOf(ledState) + (this.blue ? "255)" : "0)");
        System.out.println("[GET] RGD LED state " + ledState);
        exchange.respond(ledState);
    }

    @Override
    public void handlePUT(CoapExchange exchange) {
        block19: {
            String state;
            if (!exchange.getRequestOptions().isContentFormat(0)) break block19;
            switch (state = exchange.getRequestText()) {
                case "1": {
                    this.blue = true;
                    this.green = true;
                    this.red = true;
                    System.out.println("[PUT] Switch LED ON.");
                    break;
                }
                case "0": {
                    this.blue = false;
                    this.green = false;
                    this.red = false;
                    System.out.println("[PUT] Switch LED OFF.");
                    break;
                }
                case "r": {
                    this.red = !this.red;
                    System.out.println("[PUT] Toggle red LED.");
                    break;
                }
                case "g": {
                    this.green = !this.green;
                    System.out.println("[PUT] Toggle green LED.");
                    break;
                }
                case "b": {
                    this.blue = !this.blue;
                    System.out.println("[PUT] Toggle blue LED.");
                    break;
                }
                default: {
                    System.err.println("[PUT] Unknown LED state !");
                }
            }
        }
        exchange.respond(CoAP.ResponseCode.CHANGED);
    }

    public static void main(String[] args) {
        int port = 5683;
        if (args.length > 0) {
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                System.err.println("Port argument" + args[0] + " must be an integer.");
                System.out.println("Use default port: " + port);
                System.exit(1);
            }
        }
        CoapServer server = new CoapServer(port);
        server.add(new CoAPDummyLED());
        server.start();
    }
}

