/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.security.SecureRandom;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.TokenProvider;
import org.eclipse.californium.core.network.config.NetworkConfig;

public class InMemoryRandomTokenProvider
implements TokenProvider {
    private static final Logger LOGGER = Logger.getLogger(InMemoryRandomTokenProvider.class.getName());
    private final Set<Exchange.KeyToken> usedTokens = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final int MAX_TOKEN_LENGTH = 8;
    private final int tokenSizeLimit;
    private final SecureRandom rng;

    public InMemoryRandomTokenProvider(NetworkConfig networkConfig) {
        if (networkConfig == null) {
            throw new NullPointerException("NetworkConfig must not be null");
        }
        this.rng = new SecureRandom();
        this.tokenSizeLimit = networkConfig.getInt("TOKEN_SIZE_LIMIT", 8);
        LOGGER.log(Level.CONFIG, "using tokens of {0} bytes in length", networkConfig.getInt("TOKEN_SIZE_LIMIT", 8));
    }

    @Override
    public Exchange.KeyToken getUnusedToken(Message message) {
        return this.createUnusedToken(message);
    }

    @Override
    public void releaseToken(Exchange.KeyToken keyToken) {
        this.usedTokens.remove(keyToken);
    }

    @Override
    public boolean isTokenInUse(Exchange.KeyToken keyToken) {
        return this.usedTokens.contains(keyToken);
    }

    private Exchange.KeyToken createUnusedToken(Message message) {
        byte[] token;
        Exchange.KeyToken result;
        do {
            token = new byte[this.tokenSizeLimit];
            this.rng.nextBytes(token);
        } while (!this.usedTokens.add(result = Exchange.KeyToken.fromValues(token, message.getDestination().getAddress(), message.getDestinationPort())));
        return result;
    }
}

