/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.deduplication;

import java.util.logging.Logger;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.deduplication.CropRotation;
import org.eclipse.californium.core.network.deduplication.Deduplicator;
import org.eclipse.californium.core.network.deduplication.NoDeduplicator;
import org.eclipse.californium.core.network.deduplication.SweepDeduplicator;

public class DeduplicatorFactory {
    private static final Logger LOGGER = Logger.getLogger(DeduplicatorFactory.class.getCanonicalName());
    private static DeduplicatorFactory factory;

    public static synchronized DeduplicatorFactory getDeduplicatorFactory() {
        if (factory == null) {
            factory = new DeduplicatorFactory();
        }
        return factory;
    }

    public static synchronized void setDeduplicatorFactory(DeduplicatorFactory factory) {
        DeduplicatorFactory.factory = factory;
    }

    public Deduplicator createDeduplicator(NetworkConfig config) {
        String type;
        switch (type = config.getString("DEDUPLICATOR", "NO_DEDUPLICATOR")) {
            case "DEDUPLICATOR_MARK_AND_SWEEP": {
                return new SweepDeduplicator(config);
            }
            case "DEDUPLICATOR_CROP_ROTATION": {
                return new CropRotation(config);
            }
            case "NO_DEDUPLICATOR": {
                return new NoDeduplicator();
            }
        }
        LOGGER.warning("configuration contains unsupported deduplicator type, duplicate detection will be turned off");
        return new NoDeduplicator();
    }
}

