/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.server.resources;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;

public class CoapExchange {
    private Exchange exchange;
    private Map<String, String> queryParameters;
    private CoapResource resource;
    private String locationPath = null;
    private String locationQuery = null;
    private long maxAge = 60L;
    private byte[] eTag = null;

    public CoapExchange(Exchange exchange, CoapResource resource) {
        if (exchange == null) {
            throw new NullPointerException("exchange must not be null");
        }
        if (resource == null) {
            throw new NullPointerException("resource must not be null");
        }
        this.exchange = exchange;
        this.resource = resource;
        this.parseUriQuery();
    }

    private void parseUriQuery() {
        if (this.getRequestOptions().getURIQueryCount() > 0) {
            this.queryParameters = new HashMap<String, String>();
            for (String param : this.getRequestOptions().getUriQuery()) {
                this.addParameter(param);
            }
        }
    }

    private void addParameter(String param) {
        int idx = param.indexOf("=");
        if (idx > 0) {
            this.queryParameters.put(param.substring(0, idx), param.substring(idx + 1));
        } else {
            this.queryParameters.put(param, Boolean.TRUE.toString());
        }
    }

    public InetAddress getSourceAddress() {
        return this.exchange.getRequest().getSource();
    }

    public int getSourcePort() {
        return this.exchange.getRequest().getSourcePort();
    }

    public CoAP.Code getRequestCode() {
        return this.exchange.getRequest().getCode();
    }

    public OptionSet getRequestOptions() {
        return this.exchange.getRequest().getOptions();
    }

    public String getQueryParameter(String name) {
        if (this.queryParameters != null) {
            return this.queryParameters.get(name);
        }
        return null;
    }

    public byte[] getRequestPayload() {
        return this.exchange.getRequest().getPayload();
    }

    public String getRequestText() {
        return this.exchange.getRequest().getPayloadString();
    }

    public void accept() {
        this.exchange.sendAccept();
    }

    public void reject() {
        this.exchange.sendReject();
    }

    public void setLocationPath(String path) {
        this.locationPath = path;
    }

    public void setLocationQuery(String query) {
        this.locationQuery = query;
    }

    public void setMaxAge(long age) {
        this.maxAge = age;
    }

    public void setETag(byte[] tag) {
        this.eTag = tag;
    }

    public void respond(CoAP.ResponseCode code) {
        this.respond(new Response(code));
    }

    public void respond(String payload) {
        this.respond(CoAP.ResponseCode.CONTENT, payload);
    }

    public void respond(CoAP.ResponseCode code, String payload) {
        Response response = new Response(code);
        response.setPayload(payload);
        response.getOptions().setContentFormat(0);
        this.respond(response);
    }

    public void respond(CoAP.ResponseCode code, byte[] payload) {
        Response response = new Response(code);
        response.setPayload(payload);
        this.respond(response);
    }

    public void respond(CoAP.ResponseCode code, byte[] payload, int contentFormat) {
        Response response = new Response(code);
        response.setPayload(payload);
        response.getOptions().setContentFormat(contentFormat);
        this.respond(response);
    }

    public void respond(CoAP.ResponseCode code, String payload, int contentFormat) {
        Response response = new Response(code);
        response.setPayload(payload);
        response.getOptions().setContentFormat(contentFormat);
        this.respond(response);
    }

    public void respond(Response response) {
        if (response == null) {
            throw new NullPointerException();
        }
        if (this.locationPath != null) {
            response.getOptions().setLocationPath(this.locationPath);
        }
        if (this.locationQuery != null) {
            response.getOptions().setLocationQuery(this.locationQuery);
        }
        if (this.maxAge != 60L) {
            response.getOptions().setMaxAge(this.maxAge);
        }
        if (this.eTag != null) {
            response.getOptions().clearETags();
            response.getOptions().addETag(this.eTag);
        }
        this.resource.checkObserveRelation(this.exchange, response);
        this.exchange.sendResponse(response);
    }

    public Exchange advanced() {
        return this.exchange;
    }
}

