/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.ByteArrayOutputStream;

public final class DatagramWriter {
    private final ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
    private byte currentByte = 0;
    private int currentBitIndex = 7;

    public void writeLong(long data, int numBits) {
        if (numBits < 32 && data >= (long)(1 << numBits)) {
            throw new IllegalArgumentException(String.format("Truncating value %d to %d-bit integer", data, numBits));
        }
        int i = numBits - 1;
        while (i >= 0) {
            boolean bit;
            boolean bl = bit = (data >> i & 1L) != 0L;
            if (bit) {
                this.currentByte = (byte)(this.currentByte | 1 << this.currentBitIndex);
            }
            --this.currentBitIndex;
            if (this.currentBitIndex < 0) {
                this.writeCurrentByte();
            }
            --i;
        }
    }

    public void write(int data, int numBits) {
        if (numBits < 32 && data >= 1 << numBits) {
            throw new IllegalArgumentException(String.format("Truncating value %d to %d-bit integer", data, numBits));
        }
        int i = numBits - 1;
        while (i >= 0) {
            boolean bit;
            boolean bl = bit = (data >> i & 1) != 0;
            if (bit) {
                this.currentByte = (byte)(this.currentByte | 1 << this.currentBitIndex);
            }
            --this.currentBitIndex;
            if (this.currentBitIndex < 0) {
                this.writeCurrentByte();
            }
            --i;
        }
    }

    public void writeBytes(byte[] bytes) {
        if (bytes == null) {
            return;
        }
        if (this.currentBitIndex < 7) {
            int i = 0;
            while (i < bytes.length) {
                this.write(bytes[i], 8);
                ++i;
            }
        } else {
            this.byteStream.write(bytes, 0, bytes.length);
        }
    }

    public void writeByte(byte b) {
        this.writeBytes(new byte[]{b});
    }

    public byte[] toByteArray() {
        this.writeCurrentByte();
        byte[] byteArray = this.byteStream.toByteArray();
        this.byteStream.reset();
        return byteArray;
    }

    private void writeCurrentByte() {
        if (this.currentBitIndex < 7) {
            this.byteStream.write(this.currentByte);
            this.currentByte = 0;
            this.currentBitIndex = 7;
        }
    }

    public String toString() {
        byte[] byteArray = this.byteStream.toByteArray();
        if (byteArray != null && byteArray.length != 0) {
            StringBuilder builder = new StringBuilder(byteArray.length * 3);
            int i = 0;
            while (i < byteArray.length) {
                builder.append(String.format("%02X", 0xFF & byteArray[i]));
                if (i < byteArray.length - 1) {
                    builder.append(' ');
                }
                ++i;
            }
            return builder.toString();
        }
        return "--";
    }
}

