/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.util.logging.Logger;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.stack.AbstractLayer;
import org.eclipse.californium.core.observe.ObserveRelation;

public class TcpObserveLayer
extends AbstractLayer {
    private static final Logger LOGGER = Logger.getLogger(TcpObserveLayer.class.getName());
    private static final Integer CANCEL = 1;

    public TcpObserveLayer(NetworkConfig config) {
    }

    @Override
    public void sendRequest(Exchange exchange, Request request) {
        CANCEL.equals(request.getOptions().getObserve());
        this.lower().sendRequest(exchange, request);
    }

    @Override
    public void sendResponse(Exchange exchange, Response response) {
        ObserveRelation relation = exchange.getRelation();
        if (relation != null && relation.isEstablished()) {
            if (!response.getOptions().hasObserve()) {
                relation.cancel();
                response.setLast(true);
            } else {
                response.setLast(false);
            }
        }
        this.lower().sendResponse(exchange, response);
    }

    @Override
    public void receiveResponse(Exchange exchange, Response response) {
        if (response.getOptions().hasObserve() && exchange.getRequest().isCanceled()) {
            LOGGER.finer("Ignore notification for canceled TCP Exchange");
        } else {
            this.upper().receiveResponse(exchange, response);
        }
    }
}

