/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.tcp;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.util.List;
import org.eclipse.californium.elements.RawData;

public class DatagramFramer
extends ByteToMessageDecoder {
    public static int getLengthFieldSize(int len) {
        if (len > 15 || len < 0) {
            throw new IllegalArgumentException("Invalid len field: " + len);
        }
        if (len == 13) {
            return 1;
        }
        if (len == 14) {
            return 2;
        }
        if (len == 15) {
            return 4;
        }
        return 0;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        while (in.readableBytes() > 0) {
            byte firstByte = in.getByte(in.readerIndex());
            int lengthNibble = (firstByte & 0xF0) >>> 4;
            int tokenNibble = firstByte & 0xF;
            int lengthFieldSize = DatagramFramer.getLengthFieldSize(lengthNibble);
            int coapHeaderSize = this.getCoapHeaderSize(lengthFieldSize, tokenNibble);
            if (in.readableBytes() < coapHeaderSize) {
                return;
            }
            int bodyLength = this.getBodyLength(in, lengthNibble, lengthFieldSize);
            if (in.readableBytes() < coapHeaderSize + bodyLength) {
                return;
            }
            byte[] data = new byte[coapHeaderSize + bodyLength];
            in.readBytes(data);
            InetSocketAddress socketAddress = (InetSocketAddress)ctx.channel().remoteAddress();
            RawData rawData = new RawData(data, socketAddress);
            out.add(rawData);
        }
    }

    private int getBodyLength(ByteBuf in, int lengthNibble, int fieldSize) {
        byte[] data = new byte[fieldSize];
        in.getBytes(in.readerIndex() + 1, data);
        switch (fieldSize) {
            case 0: {
                return lengthNibble;
            }
            case 1: {
                return new BigInteger(1, data).intValue() + 13;
            }
            case 2: {
                return new BigInteger(1, data).intValue() + 269;
            }
            case 4: {
                return new BigInteger(1, data).intValue() + 65805;
            }
        }
        throw new IllegalArgumentException("Invalid field size: " + fieldSize);
    }

    private int getCoapHeaderSize(int lengthFieldSize, int tokenFieldSize) {
        return 2 + lengthFieldSize + tokenFieldSize;
    }
}

